/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.rsf;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.base.rsf.BaseRemoteSupportFacility;
import com.ibm.hwmca.base.rsf.handlers.RetainUtils;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.rsf.I_P_ProblemReportAttributes;
import com.ibm.hwmca.xfw.rsf.RsfFru;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;
import com.ibm.hwmca.xfw.rsf.RsfUpdateableComponentInfo;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class I_P_ProblemReportRequestBody
extends XFrameRsfRequestBody
implements I_P_ProblemReportAttributes {
    private static final String TRACE_MASKT = "XRSFXF T";
    private static final String TRACE_MASKF = "XRSFXF F";
    private static final String TRACE_MASKD = "XRSFXF D";
    private static String blanks = "                                ";
    private static String EBCDIC = "Cp500";
    public static final String PREFERRED_MEDIA_TYPE = "6321";
    public static final String LANGUAGE = "2924";
    static final String DOWNLOAD_DATA_AREA = "iqzmsupd.dat";
    public static final String GA1_RELEASE_LEVEL = "001";
    public static final String PMH_PLACEHOLDER = "     ";
    public static final char SYMPTOM_TYPE = '1';
    private static int neg = -256;
    private static byte[] nulls = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static String nullBytes = new String(nulls);
    private static char nullByte = nullBytes.charAt(0);
    private static byte multiLog = (byte)64;
    private static byte[] fruOffset = new byte[]{3, 127};
    private static final int fruAreaLength = 1350;
    private static final int oneFruLength = 19;
    private static final int maxFrus = 71;
    private static final String NOTELOG = "82";
    private RsfMachineInfo failingMachInfo = null;
    private Collection fruList = null;
    private Date problemDate;
    private String firmwareRelease = null;
    private HashMap firmwareLevels = new HashMap();
    private Collection updateLevels = new ArrayList();
    private String stagingDirectory;
    private ArrayList notelogData = null;
    private boolean storageRequest = false;
    private String contact;
    private String voiceNumber;
    private String voiceNumber2;
    private String modemNumber;
    private String modemNumber2;
    private String streetAddress1;
    private String streetAddress2;
    private String streetAddress3;
    private String cityState;
    private String country;
    private String company;
    private String postalCode;
    static byte baseRequestModifier = (byte)6;
    static byte fruListTruncated = I_P_ProblemReportRequestBody.assignByte(128);
    static byte noteLogExists = (byte)64;
    static byte fcdpExists = (byte)32;
    static byte legacyNotelog = 0;
    static byte extendedNotelog = (byte)64;
    private static NumberFormat nf2 = NumberFormat.getInstance();
    private static NumberFormat nf4 = NumberFormat.getInstance();

    public I_P_ProblemReportRequestBody() {
        this.problemDate = new Date();
        this.storageRequest = false;
    }

    public I_P_ProblemReportRequestBody(boolean storageRequest) {
        this.problemDate = new Date();
        this.setStorageRequest(storageRequest);
    }

    public I_P_ProblemReportRequestBody(PersistentData data) {
        super(((Persistent)data).parentData);
        this.failingMachInfo = ((Persistent)data).failingMachInfo;
        this.fruList = ((Persistent)data).fruList;
        this.problemDate = ((Persistent)data).problemDate;
        this.firmwareRelease = ((Persistent)data).firmwareRelease;
        this.firmwareLevels = ((Persistent)data).firmwareLevels;
        this.stagingDirectory = ((Persistent)data).stagingDirectory;
        this.contact = ((Persistent)data).contact;
        this.voiceNumber = ((Persistent)data).voiceNumber;
        this.voiceNumber2 = ((Persistent)data).voiceNumber2;
        this.modemNumber = ((Persistent)data).modemNumber;
        this.modemNumber2 = ((Persistent)data).modemNumber2;
        this.streetAddress1 = ((Persistent)data).streetAddress1;
        this.streetAddress2 = ((Persistent)data).streetAddress2;
        this.streetAddress3 = ((Persistent)data).streetAddress3;
        this.cityState = ((Persistent)data).cityState;
        this.country = ((Persistent)data).country;
        this.postalCode = ((Persistent)data).postalCode;
        this.company = ((Persistent)data).company;
        int version = ((Persistent)data).version;
        if (version >= 1) {
            this.notelogData = ((Persistent)data).notelogData;
            this.storageRequest = ((Persistent)data).storageRequest;
        } else {
            this.storageRequest = false;
        }
        String oldNoteLogData = this.getAttribute("Notelog");
        if (this.notelogData == null && oldNoteLogData != null) {
            this.notelogData = new ArrayList();
            this.notelogData.add(oldNoteLogData);
        }
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.failingMachInfo = this.failingMachInfo;
        result.fruList = this.fruList;
        result.problemDate = this.problemDate;
        result.firmwareRelease = this.firmwareRelease;
        result.firmwareLevels = this.firmwareLevels;
        result.stagingDirectory = this.stagingDirectory;
        result.notelogData = this.notelogData;
        result.storageRequest = this.storageRequest;
        result.contact = this.contact;
        result.voiceNumber = this.voiceNumber;
        result.voiceNumber2 = this.voiceNumber2;
        result.modemNumber = this.modemNumber;
        result.modemNumber2 = this.modemNumber2;
        result.streetAddress1 = this.streetAddress1;
        result.streetAddress2 = this.streetAddress2;
        result.streetAddress3 = this.streetAddress3;
        result.cityState = this.cityState;
        result.country = this.country;
        result.postalCode = this.postalCode;
        result.company = this.company;
        return result;
    }

    public void setStorageRequest(boolean storageRequest) {
        this.storageRequest = storageRequest;
        if (storageRequest) {
            this.requestType = "sipap";
            this.requestTypeVersion = 0;
        } else {
            this.requestType = null;
        }
    }

    public boolean isStorageRequest() {
        return this.storageRequest;
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.getAttribute("Problem Number") == null) {
            this.invalidMessage = "No problem number specified in attribute list";
        } else if (this.getAttribute("Component Id") == null) {
            this.invalidMessage = "No component id specified in attribute list";
        } else if (this.getAttribute("Severity") == null) {
            this.invalidMessage = "No severity specified in attribute list";
        } else if (this.getAttribute("Symptom String") == null) {
            this.invalidMessage = "No symptom string specified in attribute list";
        } else if (this.firmwareRelease == null) {
            this.invalidMessage = "Update information has not been initialized";
        } else {
            this.getCustomerInfo();
            return true;
        }
        Trace.trace(TRACE_MASKF, "I_P_ProblemReportRequestBody.isValid: " + this.invalidMessage);
        return false;
    }

    public void initializeUpdateInfo() {
        Trace.trace(TRACE_MASKT, " <> I_P_ProblemReportRequestBody::initializeUpdateInfo()");
        this.firmwareRelease = BaseRemoteSupportFacility.firmwareRelease;
    }

    public void initializeUpdateInfo(ManagedObject mo) {
        Trace.trace(TRACE_MASKT, "-> I_P_ProblemReportRequestBody::initializeUpdateInfo()");
        this.firmwareRelease = BaseRemoteSupportFacility.firmwareRelease;
        if (mo == null) {
            Trace.trace(TRACE_MASKT, "<- I_P_ProblemReportRequestBody::initializeUpdateInfo() managed object null");
            return;
        }
        List components = UpdateManager.getUpdateManager().getComponentsByManagedObject(mo);
        Iterator i = components.iterator();
        while (i.hasNext()) {
            Object component = i.next();
            try {
                UpdateableComponent updateComponent = (UpdateableComponent)component;
                this.updateLevels.add(new RsfUpdateableComponentInfo(updateComponent));
                String ecNumber = updateComponent.getECNumber();
                int stagedLevel = updateComponent.getStagedLevel();
                Trace.trace(TRACE_MASKF, "initializeUpdateInfo component=" + ecNumber + ":" + stagedLevel);
                this.firmwareLevels.put(ecNumber, new Integer(stagedLevel));
                String release = this.firmwareRelease;
                if (ecNumber.length() < 7 || (release = ecNumber.substring(4, 7)).compareTo(this.firmwareRelease) <= 0) continue;
                this.firmwareRelease = release;
            }
            catch (ClassCastException e) {
                Trace.trace(TRACE_MASKF, "initializeUpdateInfo: component is not an UpdateableComponent but is a " + component.getClass());
            }
        }
        Trace.trace(TRACE_MASKF, "initializeUpdateInfo release=" + this.firmwareRelease);
        try {
            this.stagingDirectory = BaseFileControl.getFilePath(DOWNLOAD_DATA_AREA);
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKT, "I_P_ProblemReportRequestBody::initializeUpdateInfo unable to use file control to get staging path.  Using default of /tmp/hmc");
            this.stagingDirectory = "/tmp/hmc";
        }
        Trace.trace(TRACE_MASKT, "<- I_P_ProblemReportRequestBody::initializeUpdateInfo()");
    }

    public String getStagingDirectory() {
        return this.stagingDirectory;
    }

    public Collection getUpdateLevels() {
        if (this.isConsoleRequest()) {
            return super.getUpdateLevels();
        }
        return this.updateLevels;
    }

    public HashMap getFirmwareLevels() {
        return this.firmwareLevels;
    }

    public void setFailingDeviceInfo(RsfMachineInfo deviceInfo) {
        this.failingMachInfo = deviceInfo;
    }

    public RsfMachineInfo getFailingDeviceInfo() {
        return this.failingMachInfo;
    }

    public void setFruList(Collection frus) {
        this.fruList = frus;
    }

    public Collection getFruList() {
        return this.fruList;
    }

    public void setDate(Date problemDate) {
        this.problemDate = problemDate;
    }

    public Date getDate() {
        return this.problemDate;
    }

    public ArrayList getNotelogs() {
        return this.notelogData;
    }

    public String buildNotelog(String[] textLines) throws IllegalArgumentException {
        if (textLines == null) {
            throw new IllegalArgumentException("Problem report notelog contains is null");
        }
        try {
            boolean multLogs = textLines.length > 23;
            this.notelogData = new ArrayList();
            byte[] recStruct = new byte[]{0, 0, 0, 0, 0, 0};
            recStruct[1] = 88;
            String recHeader = new String(recStruct, EBCDIC) + "  ";
            String totRecs = new String(I_P_ProblemReportRequestBody.calcLength(textLines.length), EBCDIC);
            byte[] bits = new byte[]{multLogs ? extendedNotelog : legacyNotelog};
            String baseNoteLogHeader = new String(bits, EBCDIC) + totRecs + nullBytes + nullBytes.substring(0, 7);
            int textLineNo = 0;
            int remainder = textLines.length;
            while (textLineNo < textLines.length) {
                int numLines = Math.min(remainder, 23);
                StringBuffer buffer = new StringBuffer(new String(I_P_ProblemReportRequestBody.calcLength(numLines), EBCDIC));
                buffer.append(baseNoteLogHeader);
                int i = 0;
                while (i < 23 && textLineNo < textLines.length) {
                    buffer.append(recHeader);
                    int textLength = textLines[textLineNo].length();
                    if (textLength > 72) {
                        buffer.append(textLines[textLineNo++].substring(0, 72));
                    } else {
                        buffer.append(textLines[textLineNo++]);
                        buffer.append(blanks.substring(0, 80 - textLength));
                    }
                    --remainder;
                    ++i;
                }
                this.notelogData.add(buffer.toString());
            }
            return (String)this.notelogData.get(0);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private String buildFruListXmlFormat(boolean toString) {
        StringBuffer buffer;
        block6: {
            if (this.fruList == null || this.fruList.isEmpty()) {
                return "";
            }
            buffer = new StringBuffer("<FRULIST>");
            if (toString) {
                buffer.append('\n');
            }
            RsfFru fru = null;
            try {
                Iterator frus = this.fruList.iterator();
                while (frus.hasNext()) {
                    buffer.append("  ");
                    fru = (RsfFru)frus.next();
                    buffer.append(" <FRU><PN>");
                    buffer.append(fru.getPartNumber());
                    buffer.append("</PN><PROB>");
                    buffer.append(fru.getConfidenceLevel());
                    buffer.append("</PROB></FRU>\n");
                }
            }
            catch (ClassCastException e) {
                Trace.trace(TRACE_MASKF, "Object in fru list is not a RsfFru");
                if (toString) break block6;
                throw e;
            }
        }
        buffer.append("</FRULIST>");
        if (toString) {
            buffer.append('\n');
        }
        return buffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String buildFruListData() {
        if (this.fruList == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        RsfFru fru = null;
        RsfMachineInfo mach = this.failingMachInfo != null ? this.failingMachInfo : this.getReportingMachineInfo();
        String type = RetainUtils.fixedLengthTextString(mach.getMachineType(), 4);
        int numFrus = 1;
        try {
            Iterator frus = this.fruList.iterator();
            while (frus.hasNext()) {
                if (numFrus > 71) {
                    return buffer.toString();
                }
                fru = (RsfFru)frus.next();
                buffer.append('P');
                buffer.append(type);
                buffer.append(RetainUtils.fixedLengthTextString(fru.getPartNumber(), 12));
                buffer.append(RetainUtils.fixedLengthTextString(fru.getConfidenceLevel(), 2));
                ++numFrus;
            }
            return buffer.toString();
        }
        catch (ClassCastException e) {
            Trace.trace(TRACE_MASKF, "Object in fru list is not a RsfFru");
            return buffer.toString();
        }
    }

    private void getCustomerInfo() {
        CustomerInfoData data = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
        String city = data.getAdminCity().trim();
        String state = data.getAdminSubdivisionCode().trim();
        int cityLength = city.length();
        int stateLength = state.length();
        this.contact = data.getAdminName();
        this.voiceNumber = data.getAdminPhone();
        this.voiceNumber2 = data.getAdminAltPhone();
        this.modemNumber = data.getAdminFax();
        this.modemNumber2 = data.getAdminAltFax();
        this.streetAddress1 = data.getAdminStreetAddr();
        this.streetAddress2 = data.getAdminStreetAddr2();
        this.streetAddress3 = "";
        this.postalCode = data.getAdminPostalCode();
        this.country = data.getAdminCountryCode();
        this.company = data.getAdminCompany();
        if (CredentialUtils.credentialDataTest) {
            if (cityLength == 0) {
                city = "Endicott";
            }
            if (stateLength == 0) {
                state = "NY";
            }
            if (this.contact == null || this.contact.trim().length() == 0) {
                this.contact = "Endicott HMC Test";
            }
            if (this.voiceNumber == null || this.voiceNumber.trim().length() == 0) {
                this.voiceNumber = "607-429-9999";
            }
            if (this.modemNumber == null || this.modemNumber.trim().length() == 0) {
                this.modemNumber = "607-429-1111";
            }
            if (this.streetAddress1 == null || this.streetAddress1.trim().length() == 0) {
                this.streetAddress1 = "1701 North Street";
            }
            if (this.postalCode == null || this.postalCode.trim().length() == 0) {
                this.postalCode = "13760";
            }
            if (this.country == null || this.country.trim().length() == 0) {
                this.country = "US";
            }
            if (this.company == null || this.company.trim().length() == 0) {
                Trace.trace(TRACE_MASKF, "IPProblemReport adding company");
                this.company = "HMC Test";
            }
        }
        if (stateLength > 0) {
            if (cityLength + stateLength > 34) {
                city = city.substring(0, 34 - stateLength);
            }
            this.cityState = city + ", " + state;
        } else {
            this.cityState = city;
        }
    }

    public String buildData() {
        StringBuffer data = new StringBuffer("20");
        RsfMachineInfo mach = this.getReportingMachineInfo();
        data.append(RetainUtils.fixedLengthTextString(mach.getMachineType(), 4));
        data.append(RetainUtils.fixedLengthTextString(mach.getMachineModel(), 3));
        data.append(RetainUtils.fixedLengthTextString(mach.getMachineFeature(), 4));
        data.append(RetainUtils.fixedLengthTextString(mach.getMachineSerial(), 9));
        data.append(RetainUtils.fixedLengthString(this.getAttribute("Lpar Id"), 1, true, nullByte));
        data.append(RetainUtils.fixedLengthTextString(this.getAttribute("Problem Number"), 10));
        data.append(' ');
        data.append('1');
        data.append(nullBytes.substring(0, 4));
        data.append("       ");
        data.append(' ');
        data.append(RetainUtils.fixedLengthTextString(this.contact, 36));
        data.append(RetainUtils.fixedLengthTextString(this.voiceNumber, 30));
        data.append(RetainUtils.fixedLengthTextString(this.voiceNumber2, 30));
        data.append(RetainUtils.fixedLengthTextString(this.modemNumber, 30));
        data.append(RetainUtils.fixedLengthTextString(this.modemNumber2, 30));
        data.append(RetainUtils.fixedLengthTextString(this.streetAddress1, 36));
        data.append(RetainUtils.fixedLengthTextString(this.streetAddress2, 36));
        data.append(RetainUtils.fixedLengthTextString(this.streetAddress3, 36));
        data.append(RetainUtils.fixedLengthTextString(this.cityState, 36));
        data.append(RetainUtils.fixedLengthTextString(this.country, 36));
        data.append(RetainUtils.fixedLengthTextString(this.postalCode, 12));
        data.append(LANGUAGE);
        data.append(RetainUtils.fixedLengthTextString(this.company, 36));
        data.append(PREFERRED_MEDIA_TYPE);
        data.append("000");
        data.append(blanks.substring(0, 4));
        data.append(blanks.substring(0, 3));
        data.append(nullBytes.substring(0, 2));
        data.append(RetainUtils.fixedLengthTextString(this.getAttribute("Component Id"), 12));
        data.append(this.firmwareRelease);
        data.append("  ");
        data.append(blanks.substring(0, 21));
        data.append(blanks.substring(0, 78));
        data.append(nullBytes.substring(0, 2));
        if (this.failingMachInfo != null) {
            Trace.trace(TRACE_MASKD, "I_P_Request.buildData: adding failing machine info");
            data.append('D');
            data.append(RetainUtils.fixedLengthTextString(this.failingMachInfo.getMachineType(), 4));
            data.append(RetainUtils.fixedLengthTextString(this.failingMachInfo.getMachineModel(), 3));
            data.append(RetainUtils.fixedLengthTextString(this.failingMachInfo.getMachineFeature(), 4));
            data.append(RetainUtils.fixedLengthTextString(this.failingMachInfo.getMachineSerial(), 9));
        } else {
            data.append(" ");
            data.append(blanks.substring(0, 20));
        }
        data.append(blanks.substring(0, 25));
        int requestModifier = baseRequestModifier;
        if (this.fruList != null && this.fruList.size() > 71) {
            Trace.trace(TRACE_MASKD, "I_P_Request.buildData: adding fru list too big bit");
            requestModifier |= fruListTruncated;
        }
        if (this.notelogData != null && !this.notelogData.isEmpty()) {
            Trace.trace(TRACE_MASKD, "I_P_Request.buildData: adding notelog bit");
            requestModifier |= noteLogExists;
        }
        if (this.getAttribute("FCDP") != null) {
            Trace.trace(TRACE_MASKD, "I_P_Request.buildData: adding fcdp bit");
            requestModifier |= fcdpExists;
        }
        byte[] rm = new byte[]{I_P_ProblemReportRequestBody.assignByte(requestModifier)};
        try {
            data.append(new String(rm, EBCDIC));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        data.append(PMH_PLACEHOLDER);
        data.append(I_P_ProblemReportRequestBody.formatDateTime(this.problemDate));
        data.append(RetainUtils.fixedLengthTextString(this.getAttribute("Severity"), 1));
        data.append('1');
        data.append(RetainUtils.fixedLengthTextString(this.getAttribute("Symptom String"), 256));
        try {
            data.append(new String(fruOffset, EBCDIC));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        int fruLength = this.fruList == null ? 0 : this.fruList.size() * 19;
        try {
            data.append(new String(I_P_ProblemReportRequestBody.calcLength(fruLength), EBCDIC));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        data.append(this.buildFruListData());
        return data.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        if (this.failingMachInfo != null) {
            buffer.append(this.failingMachInfo.toString());
        }
        buffer.append(this.buildFruListXmlFormat(true));
        return buffer.toString();
    }

    public static byte assignByte(int i) {
        if (i <= 127) {
            return (byte)i;
        }
        return (byte)(i | neg);
    }

    private static String formatDateTime(Date inDate) {
        if (inDate == null || inDate.getTime() == 0L) {
            return "000000000000";
        }
        Calendar date = Calendar.getInstance();
        date.setTime(inDate);
        StringBuffer buffer = new StringBuffer();
        buffer.append(nf4.format(date.get(1)));
        buffer.append(nf2.format(date.get(2) + 1));
        buffer.append(nf2.format(date.get(5)));
        buffer.append(nf2.format(date.get(11)));
        buffer.append(nf2.format(date.get(12)));
        return buffer.toString();
    }

    private static byte[] calcLength(int length) {
        byte[] byteLength = new byte[]{(byte)(length / 256), (byte)(length % 256)};
        return byteLength;
    }

    static {
        nf2.setMinimumIntegerDigits(2);
        nf2.setMaximumIntegerDigits(2);
        nf4.setMinimumIntegerDigits(4);
        nf4.setGroupingUsed(false);
        blanks = blanks + blanks + blanks + blanks + blanks + blanks;
    }

    private static class Persistent
    implements PersistentData {
        PersistentData parentData;
        RsfMachineInfo failingMachInfo;
        Collection fruList;
        Date problemDate;
        String firmwareRelease;
        HashMap firmwareLevels;
        ArrayList notelogData;
        String stagingDirectory;
        String contact;
        String voiceNumber;
        String voiceNumber2;
        String modemNumber;
        String modemNumber2;
        String streetAddress1;
        String streetAddress2;
        String streetAddress3;
        String cityState;
        String country;
        String postalCode;
        String company;
        boolean storageRequest;
        int version = 1;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

